/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc;

import icyllis.modernui.animation.LayoutTransition;
import icyllis.modernui.annotation.NonNull;
import icyllis.modernui.annotation.Nullable;
import icyllis.modernui.core.Context;
import icyllis.modernui.fragment.Fragment;
import icyllis.modernui.graphics.Canvas;
import icyllis.modernui.graphics.Paint;
import icyllis.modernui.graphics.Rect;
import icyllis.modernui.graphics.drawable.Drawable;
import icyllis.modernui.markdown.Markdown;
import icyllis.modernui.markdown.core.CorePlugin;
import icyllis.modernui.mc.StillAlive;
import icyllis.modernui.mc.ui.ThemeControl;
import icyllis.modernui.text.Editable;
import icyllis.modernui.text.method.LinkMovementMethod;
import icyllis.modernui.util.DataSet;
import icyllis.modernui.view.LayoutInflater;
import icyllis.modernui.view.View;
import icyllis.modernui.view.ViewGroup;
import icyllis.modernui.widget.Button;
import icyllis.modernui.widget.FrameLayout;
import icyllis.modernui.widget.TextView;
import javax.annotation.Nonnull;

public class DashboardFragment
extends Fragment {
    public static final String CREDIT_TEXT = "Modern UI 3.11.1\nby\nBloCamLimb\n(Icyllis Milica)\nCiallo\uff5e(\u2220\u30fb\u03c9< )\u2312\u2606";
    private ViewGroup mLayout;
    private TextView mSideBox;
    private TextView mInfoBox;
    final Runnable mUpdateText = this::updateText;

    @Override
    public void onAttach(@NonNull Context context) {
        super.onAttach(context);
    }

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable DataSet savedInstanceState) {
        TextView tv;
        if (this.mLayout != null) {
            return this.mLayout;
        }
        FrameLayout layout = new FrameLayout(this.requireContext());
        if (this.mSideBox == null) {
            tv = new Button(this.getContext());
            tv.setText("Still Alive");
            tv.setTextSize(16.0f);
            tv.setTextColor(-2314702);
            tv.setTextAlignment(4);
            tv.setOnClickListener(this::play);
            ThemeControl.addBackground(tv);
            this.mSideBox = tv;
        } else {
            tv = this.mSideBox;
        }
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
        params.setMarginEnd(tv.dp(120.0f));
        params.gravity = 8388629;
        layout.addView((View)tv, params);
        if (this.mInfoBox == null) {
            tv = new TextView(this.getContext());
            tv.setTextSize(16.0f);
            tv.setTextAlignment(2);
            tv.setMovementMethod(LinkMovementMethod.getInstance());
            Markdown.builder(this.requireContext()).usePlugin(CorePlugin.create()).setBufferType(TextView.BufferType.SPANNABLE).build().setMarkdown(tv, "What's New in Modern UI 3.11.1\n----\n* Brand-New Graphics Engine\n* Better Text Rendering\n* Better Mod Compatibility\n* Emoji 16.0 Support\n* Rendering Optimizations\n* [Full Changelog\u2026](https://github.com/BloCamLimb/ModernUI/blob/master/changelogs.md)\n* [Full Changelog\u2026](https://github.com/BloCamLimb/ModernUI-MC/blob/master/changelogs.md)\n \n> Author: BloCamLimb  \n  Source Code: [Modern UI](https://github.com/BloCamLimb/ModernUI)  \n  Source Code: [Modern UI (MC)](https://github.com/BloCamLimb/ModernUI-MC)");
            this.mInfoBox = tv;
        } else {
            tv = this.mInfoBox;
        }
        params = new FrameLayout.LayoutParams(-2, -2);
        params.setMarginStart(tv.dp(120.0f));
        params.gravity = 8388627;
        layout.addView((View)tv, params);
        tv = new TextView(this.getContext());
        tv.setTextSize(12.0f);
        tv.setText("Copyright \u00a9 2019-2024 BloCamLimb. All rights reserved.");
        params = new FrameLayout.LayoutParams(-2, -2);
        params.gravity = 81;
        layout.addView((View)tv, params);
        layout.setLayoutTransition(new LayoutTransition());
        this.mLayout = layout;
        return this.mLayout;
    }

    private void play(View button) {
        TextView tv = (TextView)button;
        tv.setText("", TextView.BufferType.EDITABLE);
        tv.setClickable(false);
        if (this.mInfoBox != null) {
            this.mInfoBox.setVisibility(8);
        }
        StillAlive.getInstance().start();
        this.mLayout.postDelayed(() -> {
            if (this.mLayout.isAttachedToWindow()) {
                View view = new View(this.getContext());
                view.setBackground(new Background(view));
                FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(view.dp(480.0f), view.dp(270.0f));
                params.setMarginStart(view.dp(60.0f));
                params.setMarginEnd(view.dp(30.0f));
                params.gravity = 8388627;
                this.mLayout.addView(view, params);
            }
        }, 18000L);
        this.mLayout.postDelayed(this.mUpdateText, 2000L);
    }

    private void updateText() {
        if (!this.mSideBox.isAttachedToWindow()) {
            return;
        }
        Editable editable = this.mSideBox.getEditableText();
        if (editable.length() < CREDIT_TEXT.length()) {
            editable.append(CREDIT_TEXT.charAt(editable.length()));
            if (editable.length() < CREDIT_TEXT.length()) {
                this.mSideBox.postDelayed(this.mUpdateText, 250L);
            }
        }
    }

    @Override
    public void onDetach() {
        super.onDetach();
        StillAlive.getInstance().stop();
    }

    private static class Background
    extends Drawable {
        private final float mStrokeWidth;

        private Background(View view) {
            this.mStrokeWidth = view.dp(2.0f);
        }

        @Override
        public void draw(@Nonnull Canvas canvas) {
            Rect bounds = this.getBounds();
            float inner = this.mStrokeWidth * 0.5f;
            Paint paint = Paint.obtain();
            paint.setStyle(1);
            paint.setColor(-3300456);
            paint.setStrokeWidth(this.mStrokeWidth);
            canvas.drawRoundRect((float)bounds.left + inner, (float)bounds.top + inner, (float)bounds.right - inner, (float)bounds.bottom - inner, this.mStrokeWidth * 2.0f, paint);
            paint.recycle();
            this.invalidateSelf();
        }

        @Override
        public boolean getPadding(@Nonnull Rect padding) {
            int inner = (int)Math.ceil(this.mStrokeWidth * 0.5f);
            padding.set(inner, inner, inner, inner);
            return true;
        }
    }
}

